/*
 * Decompiled with CFR 0.152.
 */
package MarieSimulator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TextFileViewer
extends JFrame {
    static final Color BACKGROUND = new Color(195, 215, 220);
    static final Color FOREGROUND = Color.black;
    static final Insets MARGINS = new Insets(5, 5, 10, 5);
    static final String HTML_CONTENT = "text/html";
    static final String ICON_IMAGE = "M.gif";
    static final String HTMLFILE_EXT = ".htm";
    static final String newLine = System.getProperty("line.separator");
    static String fileName;
    JPanel outputPane;
    JScrollPane scrollPane;
    JEditorPane displayArea = new JEditorPane();
    static JEditorPane printArea;
    JPanel printPanel = new JPanel();
    JButton printButton = new JButton("Print");
    JButton closeButton = new JButton("Close");
    boolean exitOnClose = true;

    public TextFileViewer(String string, String string2, boolean bl) {
        fileName = string2;
        this.exitOnClose = bl;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (!TextFileViewer.this.exitOnClose) {
                    TextFileViewer.this.dispose();
                    return;
                }
                System.exit(0);
            }
        });
        this.setIconImage(Toolkit.getDefaultToolkit().createImage(TextFileViewer.class.getResource(ICON_IMAGE)));
        this.outputPane = (JPanel)this.getContentPane();
        this.outputPane.setLayout(new BorderLayout());
        this.setTitle(string);
        this.displayArea.setEditable(false);
        this.displayArea.setBackground(BACKGROUND);
        this.displayArea.setForeground(FOREGROUND);
        this.displayArea.setMargin(MARGINS);
        this.displayArea.setContentType(HTML_CONTENT);
        if (fileName.endsWith(HTMLFILE_EXT)) {
            this.getHTMLContent(fileName);
            this.scrollPane = new JScrollPane(this.displayArea, 22, 31);
            this.setSize(new Dimension(350, 310));
            this.scrollPane.getViewport().add(this.displayArea);
            this.scrollPane.getViewport().setPreferredSize(new Dimension(300, 225));
        } else {
            this.getTextContent(fileName, this);
            this.scrollPane = new JScrollPane(this.displayArea, 22, 30);
            this.setSize(new Dimension(350, 360));
            this.scrollPane.getViewport().add(this.displayArea);
            this.scrollPane.getViewport().setPreferredSize(new Dimension(300, 265));
        }
        this.printPanel.setLayout(new BorderLayout());
        this.printPanel.setPreferredSize(new Dimension(300, 40));
        this.printButton.setPreferredSize(new Dimension(70, 30));
        this.printButton.setMinimumSize(new Dimension(70, 30));
        this.printButton.setMaximumSize(new Dimension(70, 30));
        this.printButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextFileViewer.this.printContent();
            }
        });
        this.printPanel.add((Component)this.printButton, "West");
        this.closeButton.setPreferredSize(new Dimension(70, 30));
        this.closeButton.setMinimumSize(new Dimension(70, 30));
        this.closeButton.setMaximumSize(new Dimension(70, 30));
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!TextFileViewer.this.exitOnClose) {
                    TextFileViewer.this.dispose();
                    return;
                }
                System.exit(0);
            }
        });
        this.printPanel.add((Component)this.closeButton, "East");
        this.outputPane.add((Component)this.scrollPane, "Center");
        this.outputPane.add((Component)this.printPanel, "South");
    }

    void getHTMLContent(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            this.displayArea.read((InputStream)fileInputStream, (Object)null);
        }
        catch (IOException iOException) {
            this.displayArea.setText(newLine + iOException);
            return;
        }
    }

    void getTextContent(String string, Object object) {
        Object object2;
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        boolean bl = false;
        InputStream inputStream = TextFileViewer.class.getResourceAsStream(string);
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            }
            catch (Exception exception) {
                this.displayArea.setText("<HTML>File " + fileNotFoundException.getMessage() + " not found.</HTML>");
                return;
            }
        }
        try {
            bufferedWriter = new BufferedWriter(new FileWriter("TextFileViewer.out"));
            bufferedWriter.write("<HTML><PRE>");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(newLine + "Error!  Cannot create file display.");
            return;
        }
        catch (IOException iOException) {
            System.err.println(newLine + "Error!  Cannot create file display.");
            return;
        }
        while (!bl) {
            try {
                object2 = bufferedReader.readLine();
                if (object2 != null) {
                    bufferedWriter.write((String)object2 + newLine);
                    continue;
                }
                bl = true;
            }
            catch (EOFException eOFException) {
                bl = true;
            }
            catch (IOException iOException) {
                bl = true;
            }
        }
        try {
            bufferedReader.close();
            bufferedWriter.write("</PRE></HTML>");
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getHTMLContent("TextFileViewer.out");
        object2 = new File("TextFileViewer.out");
        ((File)object2).delete();
    }

    void printContent() {
        PrintService printService;
        DocFlavor.INPUT_STREAM iNPUT_STREAM = DocFlavor.INPUT_STREAM.AUTOSENSE;
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(iNPUT_STREAM, hashPrintRequestAttributeSet);
        PrintService printService2 = ServiceUI.printDialog(null, 200, 200, printServiceArray, printService = PrintServiceLookup.lookupDefaultPrintService(), iNPUT_STREAM, hashPrintRequestAttributeSet);
        if (printService2 != null) {
            try {
                DocPrintJob docPrintJob = printService2.createPrintJob();
                FileInputStream fileInputStream = new FileInputStream(fileName);
                HashDocAttributeSet hashDocAttributeSet = new HashDocAttributeSet();
                SimpleDoc simpleDoc = new SimpleDoc(fileInputStream, iNPUT_STREAM, hashDocAttributeSet);
                docPrintJob.print(simpleDoc, hashPrintRequestAttributeSet);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void showFile(String string, String string2, boolean bl) {
        TextFileViewer textFileViewer = new TextFileViewer(string, string2, bl);
        textFileViewer.setVisible(true);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.err.println(newLine + "Usage: java TextFileViewer <frame title> <filename>.");
            System.exit(-1);
        }
        TextFileViewer textFileViewer = new TextFileViewer(stringArray[0], stringArray[1], true);
        textFileViewer.validate();
        textFileViewer.setVisible(true);
    }

    static {
        printArea = new JEditorPane();
    }
}

